DEFSNG A-Z
OPTION BASE 1
' $INCLUDE: 'LCOMMON.BAS'
COMMON SHARED /PLTS/BEAR,NUM$,CELEV,ADJX,ADJY,SECT%,LXOFF,LYOFF, _
	XSHIFT,YSHIFT,XDIST,HALF,VSCALE,XOFF,YOFF,BASELEV,COLWIDTH,COLSPACE, _
	VDIFF,NTYPE$,MXSCALE,MYSCALE,XWMIN,XWMAX,YWMIN,YWMAX,WCODE1%, _
	DOFF,XT%,YT%,XT,YT,NNV,HSCALE
DECLARE FUNCTION CNVRAS%(XT,XSHIFT)
DECLARE FUNCTION CNVPLT(XMAX,XMIN,MSCALE,ZOFF)
DECLARE FUNCTION SNGMIN(A,B)
DECLARE FUNCTION SNGMAX(A,B)
'ERROR TRAPPING ROUTINE FOR DEVICE I/O ERROR ON OPEN FOR PLOTTER
8370	IF ERR=57 THEN
		PRINT "DEVICE I/O ERROR ON PLOTTER - RETRYING"
	ELSE
		PRINT "ERROR CODE ";ERR;" ON OPENING PLOTTER"
		PRINT "HIT ANY KEY TO RETRY"
		IDUM$=INPUT$(1)
	END IF
	ECODE%=1
	RESUME NEXT
'ERROR ROUTINE FOR OPEN OF BATCH PLOT FILE
8480	PRINT "AN ERROR HAS OCCURRED IN OPEN OF PLOT CONTROL FILE ";BATFIL$
	PRINT "RETURNING TO ALLOW RE-ENTRY."
	ECODE%=1
	RESUME NEXT
'ERROR ROUTINE FOR OPENING PROJECTION PARAMETERS FILE
8750	PRINT "AN ERROR HAS OCCURRED OPENING PROJECTION PARAMETERS FILE"
	PRINT "RETURNING TO ALLOW RE-ENTRY."
	ECODE%=1
	RESUME NEXT
'ERROR  ROUTINE FOR OPENING LIST OF WELLS FILE (OPTION 3)
8755	PRINT "AN ERROR HAS OCCURRED OPENING FILE CONTAINING"
	PRINT "LIST OF OF WELL IDENTIFICATIONS - TERMINATING PLOT"
	ECODE%=1
	RESUME NEXT 
SUB PlotSection(FILNAM$) STATIC
'
' SUBROUTINE TO PLOT SECTION VIEW ON HP PLOTTER
'
	FMT5$="\          \!  ####.###"
	OPEN "CONFIG.PLT" FOR INPUT AS #1
	INPUT #1,PLOTTER$
	CLOSE #1
	CLS
	CALL TTINAA(0,0,"DO YOU WANT TO USE THE ONLINE PLOTTER?(Y/N): ",ONLINE$,"","Y")
	ONLINE$=UCASE$(ONLINE$)
	IF ONLINE$ = "Y" THEN
		PRINT "PLOTTER SHOULD BE TURNED ON AND PAPER LOADED"
		PRINT "HIT ANY KEY WHEN READY"
		IDUM$=INPUT$(1)
		OPEN PLOTTER$ AS #4
4006		ON ERROR GOTO 8370                'TRAP ROUTINE
		ECODE%=0
		PRINT #4,"IN;";CHR$(27);".L":INPUT #4,L
		ON ERROR GOTO 0
		IF ECODE%=1 GOTO 4006
	ELSE
		CALL TTINAA(0,0,"ENTER DISK FILENAME: ",PLOTTER$,"","Y")
RET:		INPUT "P1X,P1Y,P2X,P2Y: ",P1X,P1Y,P2X,P2Y
		IF (P2X <= P1X OR P2Y <= P1Y) THEN
			PRINT "INVALID RESPONSE- RANGE OF X AND/OR Y INCORRECT - TRY AGAIN"
			GOTO RET
		END IF
		OPEN PLOTTER$ FOR OUTPUT AS #4
		SYMFIL$="CONFIG.PLT"
	END IF
'
'go setup latitude-longitude to xy projection parameters
DPR2:	ECODE%=0
	CALL TTINAA(0,0,"ENTER FILENAME OF PROJECTION PARAMETERS: ",TEMP$,PRJNAM$,"Y")
	IF TEMP$="" THEN
		CLOSE #4
		EXIT SUB
	END IF
	PRJNAM$=TEMP$
	ON ERROR GOTO 8750
	OPEN PRJNAM$ FOR INPUT AS #5
	ON ERROR GOTO 0
	IF ECODE%=1 THEN
		PRJNAM$=""
		GOTO DPR2
	END IF
	ECODE%=0
	CALL SetupProjection(PTYP%,DARRAY#(),CM#,ECODE%)
	IF ECODE%=1 THEN
		PRJNAM$=""
		GOTO DPR2
	END IF
	CALL OpenFiles(FILNAM$)
	CALL ReadFirst(NoOfWells,FirstRecord,FinalRecord,NNV,TITLE$,DBWLL#())
	CALL TTINAA(0,0,"DO YOU WANT TO PLOT THE NUMERIC VARIABLES?(Y/N): ",NUM$,"","Y")
	NUM$=UCASE$(NUM$)
	IF NUM$="Y" THEN
3997		CALL TTINAA(0,0,"ENTER PLOT CONTROL FILE FOR NUMERIC TRACE: ",BATFIL$,"","Y")
		ECODE%=0
		ON ERROR GOTO 8480
		OPEN BATFIL$ FOR INPUT AS #1
		ON ERROR GOTO 0
		IF ECODE%<>0 GOTO 3997
		INPUT #1,NTYPE$
		NTYPE$=UCASE$(NTYPE$)
		IF NTYPE$="TRACE" THEN
			FOR I%=1 TO NNV
			INPUT #1,NPEN%(I%),NLT%(I%),NBASE(I%),NSCALE(I%)
			NEXT I%
		ELSE
			FOR I%=1 TO NNV
				INPUT #1,NBASE(I%),NSCALE(I%), _
					HistPats(I%,1),HistPats(I%,2), _
					HistPats(I%,3),HistPats(I%,4), _
					HistPats(I%,5)
			NEXT I%
		END IF
		CLOSE #1
	END IF
4000	ECODE%=0
	CALL TTINAA(0,0,"ENTER PLOT CONTROL FILENAME: ",BATFIL$,"","Y")
	ON ERROR GOTO 8480
	OPEN BATFIL$ FOR INPUT AS #1
	ON ERROR GOTO 0
	IF ECODE%<>0 GOTO 4000
	INPUT #1,SECT%
	INPUT #1,BASELEV,ENDELEV,VSCALE,TICK,COLWIDTH
	IF ENDELEV <= BASELEV THEN
		PRINT "BASE ELEVATION IS < OR = TO ENDING ELEVATION"
		GOTO 4235
	END IF
	IF VSCALE <= 0.0 THEN
		PRINT "VERTICAL SCALE <= ZERO"
		GOTO 4235
	END IF
	INPUT #1,HSCALE
	IF HSCALE <= 0.0 THEN
		PRINT "HORIZONTAL SCALE <= ZERO"
		GOTO 4235
	END IF
	IF COLWIDTH < 0.0 THEN
		PRINT "WIDTH OF COLUMN IS < ZERO"
		GOTO 4235
	END IF
	INPUT #1,XOFF,YOFF
	INPUT #1,RT$
	RT$=UCASE$(RT$)
	INPUT #1,SPEED,FORCE
	INPUT #1,WDH,HGH
	IF WDH <= 0.0 OR HGH <= 0.0 THEN
		PRINT "WARNING!! HEIGHT OR WIDTH OF LABELING IS <= ZERO USING WDH=0.1 HGH=0.15"
		WDH=0.1
		HGH=0.15
	END IF
	INPUT #1,TEMP1$,TEMP2$,DATUM
	IF TEMP1$="NOSTRAT" THEN
		STRAT$="N"
	ELSE
		STRAT$="Y"
		STRLEN%=LEN(TEMP1$)
		RESBED1$=STRING$(8," ")
		MID$(RESBED1$,1,STRLEN%)=TEMP1$
		IF TEMP2$="" THEN
			RESBED2$=""
		ELSE
			STRLEN%=LEN(TEMP2$)
			RESBED2$=STRING$(8," ")
			MID$(RESBED2$,1,STRLEN%)=TEMP2$
		END IF
	END IF
4005	INPUT #1,LEGEND$,LXOFF,LYOFF
	LEGEND$=UCASE$(LEGEND$)
	IBAT$="Y"
	IF SECT%=3 THEN
		EXPORT$="N"
	ELSE
		CALL CORNER(1%,IBAT$,GEOG#(2),GEOG#(1))
		JOB%=1
		CALL PROJECT(GEOG#(),PROJ#(),ZONE%,PTYP%,JOB%,DARRAY#())
		CALL CON2FT(PROJ#(1),PROJ#(2),UXP#,UYP#)
		XS1=UXP#
		YS1=UYP#
		CALL CORNER(1%,IBAT$,GEOG#(2),GEOG#(1))
		JOB%=1
		CALL PROJECT(GEOG#(),PROJ#(),ZONE%,PTYP%,JOB%,DARRAY#())
		CALL CON2FT(PROJ#(1),PROJ#(2),UXP#,UYP#)
		XS2=UXP#
		YS2=UYP#
		CSDIST=SQR((XS2-XS1)*(XS2-XS1) + (YS2-YS1)*(YS2-YS1))
		DX=XS2-XS1
		DY=YS2-YS1
		LENG=SQR(DX^2 + DY^2)
		IF LENG>0 THEN
			IF DX = 0 THEN
				IF DY>0 THEN
					BEAR=0
				ELSE
					BEAR=3.1415927#
				END IF
			ELSEIF DY = 0 THEN
				IF DX>0 THEN
					BEAR=1.5707963#
				ELSE
					BEAR=4.71238
				END IF
			ELSE
				ANG=ATN(DY/DX)
				IF DX>0 THEN
					BEAR=1.5707963#-ANG
				ELSE
					BEAR=4.712389-ANG
				END IF
			END IF
		END IF
		A=YS2-YS1
		B=-1*(XS2-XS1)
		C=YS1*(XS2-XS1)-XS1*(YS2-YS1)
		CALL TTINAA(0,0,"CREATE AN ASCII FILE CONTAINING WELL #, DISTANCE DOWN SECTION?(Y/N): ", _
			EXPORT$,"","Y")
		EXPORT$=UCASE$(EXPORT$) 
		IF EXPORT$="Y" THEN
			CALL TTINAA(0,0,"ENTER FILENAME: ",EXPFIL$,"","Y")
			OPEN EXPFIL$ FOR OUTPUT AS #6
		END IF
	END IF
'go setup plotter and parameters specific to plotter
	CALL InitializePlotter(ONLINE$,RT$,PCT(),SPEED,FORCE,OPT6%,OPT8%, _
		XSHIFT,YSHIFT,P1X,P1Y,P2X,P2Y)
	CALL SetPen(1)
	CALL SetLine(0,PCT())
	CALL SetMode(0)
	CALL SetCharSize(WDH,HGH)
	CALL SetPenStatus(0)
'SINCE WE DONT KNOW SIZE IN ADVANCE SET UP FOR INFINITE WINDOW
	MXSCALE=1.0
	MYSCALE=1.0
	XWMIN=-1.0E23
	XWMAX=1.0E23
	YWMIN=-1.0E23
	YWMAX=1.0E23
	IF LEGEND$="Y" THEN CALL PlotLegend
	YWMIN=0.0
	YWMAX = (ENDELEV-BASELEV)/VSCALE
'
' Draw vertical axis
'
	XP=XOFF
	XP%=CNVRAS%(XP,XSHIFT)
	TEMP%=XP%-100
	CALL SetCharSize(0.1,0.15)
	FOR H=BASELEV TO ENDELEV STEP TICK
		YP=((H-BASELEV)/VSCALE)+YOFF
		YP%=CNVRAS%(YP,YSHIFT)
		CALL MoveTo(0,TEMP%,YP%)
		CALL LineTo(0,XP%,YP%)
		TEMP1=(H/VSCALE)-INT(H/VSCALE)
		IF TEMP1<>0 GOTO 4015
		TEMP$=STR$(INT(H))
		I1%=LEN(TEMP$)
		TEMP1%=(I1%*0.1)*1016 + 100
		TEMP1%=TEMP%-TEMP1%
		CALL MoveTo(0,TEMP1%,YP%)
		LLB$="LB"+TEMP$+CHR$(3)
		CALL DrawCharStr(LLB$)
4015	NEXT H
	CALL SetCharSize(WDH,HGH)
	CALL MoveTo(0,XP%,YP%)
	YP=YOFF:YP%=CNVRAS%(YP,YSHIFT)
	CALL LineTo(0,XP%,YP%)
	CALL SetPenStatus(0)
	XDIST=XOFF
	HALF=0.5*COLWIDTH
	CALL SetCharDir(90)
	LOCATE 25,1
	PRINT "FUNCTION KEY 9 TO PAUSE, THEN Q TO QUIT, RETURN TO CONTINUE";
	TCODE%=0
	KEY(9) ON
	IDUMMY$=""
	IF SECT%=2 GOTO 4030
	IF SECT%=3 GOTO 4100
'
' Routine to plot wells within a specified distance of section line
' (OPTION 1)
4019	INPUT #1,OKDIST
	FOR I% = 1 TO NoOfWells
		J=I%+1
		CALL ReadId(J,WellIdent$,TopElev,TotalDepth,StartingRecord,EndingRecord, _
			WellLat#,WellLon#,Bearing,Plunge)
		IF StartingRecord > 0 THEN
			GEOG#(2)=WellLat#
			GEOG#(1)=WellLon#
			JOB%=1
			CALL PROJECT(GEOG#(),PROJ#(),ZONE%,PTYP%,JOB%,DARRAY#())
			CALL CON2FT(PROJ#(1),PROJ#(2),UXP#,UYP#)
			UXP=UXP#
			UYP=UYP#
			DIST=ABS((A*UXP+B*UYP+C)/SQR(A*A + B*B))
			IF DIST<=OKDIST THEN
				DIST1=SQR((UXP-XS1)*(UXP-XS1) + (UYP-YS1)*(UYP-YS1))
				DIST2=SQR((UXP-XS2)*(UXP-XS2) + (UYP-YS2)*(UYP-YS2))
				IF DIST1<=CSDIST AND DIST2<=CSDIST THEN
					XDIST=12.0*SQR((DIST1*DIST1)-(DIST*DIST))
					XDIST=XOFF+(XDIST/HSCALE)
					CALL PlotWellSection(WellIdent$,TopElev,TotalDepth,StartingRecord,EndingRecord, _
						UXP,UYP,Bearing,Plunge,XDIST,HALF)
					IF EXPORT$="Y" THEN
						PRINT #6, USING FMT5$;WellIdent$,CHR$(44),XDIST-XOFF
					END IF
					CALL SetPen(1)
				END IF
			END IF
		END IF
4020    	IF TCODE%=1 GOTO 4235
	NEXT I%
	XDIST=XOFF+(12.0*CSDIST/HSCALE)
	IF EXPORT$="Y" THEN
		WellIdent$=CHR$(34)+"          "+CHR$(34)
		PRINT #6,USING FMT5$;WellIdent$,CHR$(44),XDIST-XOFF
	END IF
	GOTO 4231
'
' Get Well Number to Plot (OPTION 2)
'
4030	IF EOF(1)<0 THEN
		XDIST=XOFF+(12.0*CSDIST/HSCALE)
		IF EXPORT$="Y" THEN
			WellIdent$=CHR$(34)+"          "+CHR$(34)
			PRINT #6,USING FMT5$;WellIdent$,CHR$(44),XDIST-XOFF
		END IF
		GOTO 4231
	ELSE
		INPUT #1,TEMP$
		CALL PAD(TEMP$,TestValue$,12)
		IF IDUMMY$="Q" GOTO 4235
	END IF
4034	ECODE%=0
	FOR I = 1 TO NoOfWells
		J=I+1
		CALL ReadId(J,WellIdent$,TopElev,TotalDepth,StartingRecord,EndingRecord, _
			WellLat#,WellLon#,Bearing,Plunge)
		IF TestValue$=WellIdent$ THEN
			IF StartingRecord < 0 THEN
				PRINT TestValue$;" - WELL HAS BEEN DELETED"
				PRINT "CONTINUING TO SEARCH FOR POSSIBLE REENTRY"
				ECODE%=1
				GOTO 4035 
			END IF
			IF TopElev=0 AND TotalDepth=0 THEN
				PRINT "NO DATA FOR WELL ";TestValue$
				ECODE%=1
				GOTO 4035
			END IF
			GOTO 4040
		END IF
4035		IF TCODE%=1 GOTO 4235
	NEXT I
	IF ECODE%=0 THEN
		PRINT "WELL NUMBER ";TestValue$;" NOT FOUND IN FILE"
	END IF
	GOTO 4030
4040	GEOG#(2)=WellLat#
	GEOG#(1)=WellLon#
	JOB%=1
	CALL PROJECT(GEOG#(),PROJ#(),ZONE%,PTYP%,JOB%,DARRAY#())
	CALL CON2FT(PROJ#(1),PROJ#(2),UXP#,UYP#)
	UXP=UXP#
	UYP=UYP#
	DIST=ABS((A*UXP+B*UYP+C)/SQR(A*A + B*B))
	DIST1=SQR((UXP-XS1)*(UXP-XS1) + (UYP-YS1)*(UYP-YS1))
	XDIST=12.0*SQR((DIST1*DIST1)-(DIST*DIST))
	XDIST=XOFF+(XDIST/HSCALE)
	CALL PlotWellSection(WellIdent$,TopElev,TotalDepth,StartingRecord,EndingRecord, _
		UXP,UYP,Bearing,Plunge,XDIST,HALF)
	IF EXPORT$="Y" THEN
		PRINT #6, USING FMT5$;WellIdent$,CHR$(44),XDIST-XOFF
	END IF
	CALL SetPen(1)
	GOTO 4030
'
' (OPTION 3)
4100	INPUT #1,EXPFIL$
	CLOSE #1
	ECODE%=0
	ON ERROR GOTO 8755
	OPEN EXPFIL$ FOR INPUT AS #1
	ON ERROR GOTO 0
	IF ECODE%=1 GOTO 4235
4110	INPUT #1,TEMP$,XDIST
	CALL PAD(TEMP$,TestValue$,12)
	IF TestValue$="            " THEN
		XDIST=XDIST+XOFF
		GOTO 4231
	END IF
	ECODE%=0
	FOR I = 1 TO NoOfWells
		J=I+1
		CALL ReadId(J,WellIdent$,TopElev,TotalDepth,StartingRecord,EndingRecord, _
			WellLat#,WellLon#,Bearing,Plunge)
		IF TestValue$=WellIdent$ THEN
			IF StartingRecord < 0 THEN
				PRINT TestValue$;" - WELL HAS BEEN DELETED"
				PRINT "CONTINUING TO SEARCH FOR POSSIBLE REENTRY"
				ECODE%=1
				GOTO 4135 
			END IF
			IF TopElev=0 AND TotalDepth=0 THEN
				PRINT "NO DATA FOR WELL ";TestValue$
				ECODE%=1
				GO TO 4135
			END IF
			GOTO 4140
		END IF
4135    	IF TCODE%=1 GOTO 4235
	NEXT I
	IF ECODE%=0 THEN
		PRINT "WELL NUMBER ";TestValue$;" NOT FOUND IN FILE"
	END IF
	GOTO 4110
4140	XDIST=XDIST+XOFF
	CALL PlotWellSection(WellIdent$,TopElev,TotalDepth,StartingRecord,EndingRecord, _
		UXP,UYP,Bearing,Plunge,XDIST,HALF)
	CALL SetPen(1)
	GOTO 4110
'
' Draw right vertical axis
'
4231	IF IDUMMY$="Q" GOTO 4235
	XP=XDIST
	XP%=CNVRAS%(XP,XSHIFT)
	TEMP%=XP%+100
	CALL SetCharDir(0)
	CALL SetCharSize(0.1,0.15)
	FOR H=BASELEV TO ENDELEV STEP TICK
		YP=((H-BASELEV)/VSCALE)+YOFF:YP%=CNVRAS%(YP,YSHIFT)
		CALL MoveTo(0,XP%,YP%)
		CALL LineTo(0,TEMP%,YP%)
		TEMP1=(H/VSCALE)-INT(H/VSCALE)
		IF TEMP1<>0 GOTO 4232
		TEMP$=STR$(INT(H))
		I1%=LEN(TEMP$)
		TEMP1%=TEMP% + 100
		CALL MoveTo(0,TEMP1%,YP%)
		LLB$="LB"+TEMP$+CHR$(3)
		CALL DrawCharStr(LLB$)
4232	NEXT H
	CALL MoveTo(0,XP%,YP%)
	YP=YOFF:YP%=CNVRAS%(YP,YSHIFT)
	CALL LineTo(0,XP%,YP%)
4235	CLOSE #1, #2, #3
	KEY(9) OFF
	CALL SetPen(0)
	CLOSE #4
	IF EXPORT$="Y" THEN CLOSE #6
	STRAT$="N"
END SUB
SUB PlotWellSection(WellIdent$,TopElev,TotalDepth,StartingRecord,EndingRecord, _
	WellX,WellY,Bearing,Plunge,XDIST,HALF) STATIC
DIM PX(5),PY(5),XO(5),YO(5)
'
' Get Well Data 
'
	IF SECT%=1 OR SECT%=2 THEN
		ConvertToElevations$="Y"
		ConvertToTrueDepth$="Y"
		CALL ReadWellData(StartingRecord,EndingRecord,Icnt%,BedIdent$(), _
			TopOfBed(),BottomOfBed(),NUMB(),ConvertToTrueDepth$, _
			ConvertToElevations$,Plunge,TopElev,VDIFF)
		ALP=ABS((0.01745329*Bearing)-BEAR)
		TrueDepth=TotalDepth*SIN(0.01745329*Plunge)
		DELTAX=(TotalDepth*COS(0.01745329*Plunge))*COS(ALP)
		APLUNGE=ABS(ATN((TrueDepth/VSCALE)/(DELTAX*12./HSCALE)))
		IF ABS(ALP)<= 1.570796 OR ABS(ALP)>= 4.712389 THEN
			PLTANG=-1*(1.570796-APLUNGE)
		ELSE
			PLTANG=1.570796-APLUNGE
		END IF
	ELSE
		ConvertToElevations$="Y"
		ConvertToTrueDepth$="N"
		CALL ReadWellData(StartingRecord,EndingRecord,Icnt%,BedIdent$(), _
			TopOfBed(),BottomOfBed(),NUMB(),ConvertToTrueDepth$, _
			ConvertToElevations$,Plunge,TopElev,VDIFF)
		TrueDepth=TotalDepth
		PLTANG=0.0
		APLUNGE=1.570796
	END IF
	IF Icnt%=0 OR TotalDepth=0.0 GOTO PWS3
	SINAPP=SIN(APLUNGE)
	ApparentDepth=TrueDepth/SINAPP
	FOR I%=1 TO Icnt%
		TopOfBed(I%)=TopElev-((TopElev-TopOfBed(I%))/SINAPP)
		BottomOfBed(I%)=TopElev-((TopElev-BottomOfBed(I%)))/SINAPP
	NEXT I%
'	
' Plot Outline
' 
PWS0:	PX(1)=XDIST-HALF
	PY(1)=((TopElev-BASELEV)/VSCALE)
	PX(2)=XDIST+HALF
	PY(2)=PY(1)
	PX(3)=PX(2)
	PY(3)=(((TopElev-ApparentDepth)-BASELEV)/VSCALE)
	PX(4)=PX(1)
	PY(4)=PY(3)
	PX(5)=PX(1)
	PY(5)=PY(1)
	N%=5
	SAVY=PY(1)
	FOR I%=1 TO N%
		NEWX=PX(I%)-XDIST
		NEWY=PY(I%)-SAVY
		TRX=NEWX*COS(PLTANG)+NEWY*SIN(PLTANG)
		TRY=NEWY*COS(PLTANG)-NEWX*SIN(PLTANG)
		PX(I%)=TRX+XDIST
		PY(I%)=TRY+SAVY
	NEXT I%
	CALL CheckLineAgainstWindow(N%,PX(),PY(),MXSCALE,MYSCALE, _
		DOFF,YOFF,XSHIFT,YSHIFT,XWMIN,XWMAX,YWMIN,YWMAX)
	XP%=CNVRAS%(XDIST+0.05,XSHIFT)
	YP=((TopElev-BASELEV)/VSCALE)
	IF YP > YWMAX THEN
		YP = YWMAX
	END IF
	YP = YP + YOFF + 0.1
	YP%=CNVRAS%(YP,YSHIFT)
	LLB$="LB "+WellIdent$+CHR$(3)
	CALL MoveTo(0,XP%,YP%)
	CALL DrawCharStr(LLB$)
'
' Plot it
' 
	J=1
	K=1
PWS:	FILL%=0
	FOR IJK%=1 TO BedCnt%
		STRLEN%=LEN(ValidBedIdents$(IJK%))
		TEMP$=STRING$(8," ")
		MID$(TEMP$,1,STRLEN%)=ValidBedIdents$(IJK%)
		IF BedIdent$(J)=TEMP$ THEN
			PN%=FillPats(IJK%,1)
			LT%=FillPats(IJK%,2)
			FILL%=FillPats(IJK%,3)
			SPACE=FillPats(IJK%,4)
			ANGLE=FillPats(IJK%,5)
			GOTO PWS1
		END IF
	NEXT IJK%
	K=J
	GOTO PWS2
PWS1:	FOR IJK%=J+1 TO Icnt%
		IF BedIdent$(IJK%)<>TEMP$ THEN
			K=IJK%-1
			GOTO PWS1A
		END IF
	NEXT IJK%
	K=Icnt%
PWS1A:	CALL SetLine(LT%,PCT())
	CALL SetPen(PN%)
	PX(1)=XDIST-HALF
	PY(1)=((BottomOfBed(K)-BASELEV)/VSCALE)
	PX(2)=XDIST+HALF:PY(2)=PY(1)
	PX(3)=PX(2)
	PY(3)=((TopOfBed(J)-BASELEV)/VSCALE)
	PX(4)=XDIST-HALF
	PY(4)=PY(3)
	PX(5)=PX(4)
	PY(5)=PY(1)
	N%=5
	FOR I%=1 TO N%
		NEWX=PX(I%)-XDIST
		NEWY=PY(I%)-SAVY
		TRX=NEWX*COS(PLTANG)+NEWY*SIN(PLTANG)
		TRY=NEWY*COS(PLTANG)-NEWX*SIN(PLTANG)
		PX(I%)=TRX+XDIST
		PY(I%)=TRY+SAVY
	NEXT I%
	DOFF=0.
	ANGLE=ANGLE-PLTANG/0.01745329
	IF FILL%=1 THEN
		CALL HATCH(N%,PX(),PY(),XO(),YO(),ANGLE,SPACE,MXSCALE, _
			MYSCALE,DOFF,YOFF,XSHIFT,YSHIFT,XWMIN,XWMAX,YWMIN,YWMAX)
	END IF
	IF FILL%=2 THEN
		CALL HATCH(N%,PX(),PY(),XO(),YO(),ANGLE,SPACE,MXSCALE, _
			MYSCALE,DOFF,YOFF,XSHIFT,YSHIFT,XWMIN,XWMAX,YWMIN,YWMAX)
		ANGLE=ANGLE+90
		CALL HATCH(N%,PX(),PY(),XO(),YO(),ANGLE,SPACE,MXSCALE, _
			MYSCALE,DOFF,YOFF,XSHIFT,YSHIFT,XWMIN,XWMAX,YWMIN,YWMAX)
	END IF
	CALL SetLine(0,PCT())
	CALL CheckLineAgainstWindow(N%,PX(),PY(),MXSCALE,MYSCALE, _
		DOFF,YOFF,XSHIFT,YSHIFT,XWMIN,XWMAX,YWMIN,YWMAX)
	CALL SetPenStatus(0) 
PWS2:	J=K+1
	IF J<=Icnt% GOTO PWS
	IF NUM$="Y" THEN
		FOR K=1 TO NNV
			IF NSCALE(K)<>0 THEN
				IF NTYPE$="TRACE" THEN
					CALL SetPen(NPEN%(K))
					CALL SetLine(NLT%(K),PCT())
					XB=XDIST+HALF
					XP=XB+((NUMB(1,K)-NBASE(K))/NSCALE(K))
					YP=((BottomOfBed(1)-BASELEV)/VSCALE)
					NEWX=XP-XDIST
					NEWY=YP-SAVY
					TRX=NEWX*COS(PLTANG)+NEWY*SIN(PLTANG)
					TRY=NEWY*COS(PLTANG)-NEWX*SIN(PLTANG)
					XP=TRX+XDIST
					YP=TRY+SAVY
					XP%=CNVRAS%(XP,XSHIFT)
					YP%=CNVRAS%(YP+YOFF,YSHIFT)
					CALL MoveTo(0,XP%,YP%)
					FOR J=2 TO Icnt%
						YP=((BottomOfBed(J)-BASELEV)/VSCALE)
						XP=XB+(NUMB(J,K)-NBASE(K))/NSCALE(K)
						NEWX=XP-XDIST
						NEWY=YP-SAVY
						TRX=NEWX*COS(PLTANG)+NEWY*SIN(PLTANG)
						TRY=NEWY*COS(PLTANG)-NEWX*SIN(PLTANG)
						XP=TRX+XDIST
						YP=TRY+SAVY
						XP%=CNVRAS%(XP,XSHIFT)
						YP%=CNVRAS%(YP+YOFF,YSHIFT)
						CALL LineTo(0,XP%,YP%)
					NEXT J
				ELSE
					HISTANG=PLTANG
					PN%=HistPats(K,1)
					LT%=HistPats(K,2)
					FILL%=HistPats(K,3)
					SPACE=HistPats(K,4)
					ANGLE=HistPats(K,5)
					ANGLE=ANGLE-HISTANG/0.01745329
					CALL SetPen(PN%)
					CALL SetLine(LT%,PCT())
					SAVY=(TopElev-BASELEV)/VSCALE
					XB=XDIST+HALF
					FOR J=1 TO Icnt%
						PX(1)=XB
						PY(1)=((TopOfBed(J)-BASELEV)/VSCALE)
						PX(2)=XB + (NUMB(J,K)-NBASE(K))/NSCALE(K)
						PY(2)=PY(1)
						PX(3)=PX(2)
						PY(3)=((BottomOfBed(J)-BASELEV)/VSCALE)
						PX(4)=PX(1)
						PY(4)=PY(3)
						PX(5)=PX(1)
						PY(5)=PY(1)
						N%=5
						FOR I%=1 TO N%
							NEWX=PX(I%)-XDIST
							NEWY=PY(I%)-SAVY
							TRX=NEWX*COS(HISTANG)+NEWY*SIN(HISTANG)
							TRY=NEWY*COS(HISTANG)-NEWX*SIN(HISTANG)
							PX(I%)=TRX+XDIST
							PY(I%)=TRY+SAVY
						NEXT I%
						DOFF=0.
						IF FILL%=1 THEN
							CALL HATCH(N%,PX(),PY(),XO(),YO(),ANGLE,SPACE,MXSCALE, _
								MYSCALE,DOFF,YOFF,XSHIFT,YSHIFT,XWMIN,XWMAX,YWMIN,YWMAX)
						END IF
						IF FILL%=2 THEN
							CALL HATCH(N%,PX(),PY(),XO(),YO(),ANGLE,SPACE,MXSCALE, _
								MYSCALE,DOFF,YOFF,XSHIFT,YSHIFT,XWMIN,XWMAX,YWMIN,YWMAX)
							ANGLE=ANGLE+90
							CALL HATCH(N%,PX(),PY(),XO(),YO(),ANGLE,SPACE,MXSCALE, _
								MYSCALE,DOFF,YOFF,XSHIFT,YSHIFT,XWMIN,XWMAX,YWMIN,YWMAX)
						END IF
						CALL SetLine(0,PCT())
						CALL CheckLineAgainstWindow(N%,PX(),PY(),MXSCALE,MYSCALE, _
							DOFF,YOFF,XSHIFT,YSHIFT,XWMIN,XWMAX,YWMIN,YWMAX)
						CALL SetPenStatus(0) 
					NEXT J
				END IF
			END IF
		NEXT K
	END IF
PWS3:   CALL SetLine(0,PCT())
END SUB
SUB PlotLegend STATIC
DIM PX(5),PY(5),XO(5),YO(5)
	TX=LXOFF
	TY=LYOFF
	FOR IJK%=1 TO BedCnt%
PL1:		XP%=CNVRAS%(TX+COLWIDTH+0.1,XSHIFT)
		YP%=CNVRAS%(TY-0.25,YSHIFT)
		CALL MoveTO(0,XP%,YP%)
		CALL SetPen(1)
		CALL SetLine(0,PCT())
		LBL$="LB"+ValidBedIdents$(IJK%)+CHR$(3)
		CALL DrawCharStr(LBL$)
		TY=TY-.35
	NEXT IJK%
	TY=LYOFF
	FOR IJK%=1 TO BedCnt%
		PX(1)=TX:PY(1)=TY
		PX(2)=TX+COLWIDTH:PY(2)=PY(1)
		PX(3)=PX(2):PY(3)=TY-0.25
		PX(4)=TX:PY(4)=PY(3)
		PX(5)=PX(4):PY(5)=TY
		N%=5
		DOFF=0.
		PN%=FillPats(IJK%,1)
		LT%=FillPats(IJK%,2)
		FILL%=FillPats(IJK%,3)
		SPACE=FillPats(IJK%,4)
		ANGLE=FillPats(IJK%,5)
		CALL SetPen(PN%)
		CALL SetLine(LT%,PCT())
		IF FILL%=1 THEN
			CALL HATCH(N%,PX(),PY(),XO(),YO(),ANGLE,SPACE,MXSCALE, _
				MYSCALE,DOFF,DOFF,XSHIFT,YSHIFT,XWMIN,XWMAX,YWMIN,YWMAX)
		ELSE
			CALL HATCH(N%,PX(),PY(),XO(),YO(),ANGLE,SPACE,MXSCALE, _
				MYSCALE,DOFF,DOFF,XSHIFT,YSHIFT,XWMIN,XWMAX,YWMIN,YWMAX)
			ANGLE=ANGLE+90
			CALL HATCH(N%,PX(),PY(),XO(),YO(),ANGLE,SPACE,MXSCALE,  _
				MYSCALE,DOFF,DOFF,XSHIFT,YSHIFT,XWMIN,XWMAX,YWMIN,YWMAX)
		END IF
		CALL SetLine(0,PCT())
		CALL CheckLineAgainstWindow(N%,PX(),PY(),MXSCALE,MYSCALE, _
			DOFF,DOFF,XSHIFT,YSHIFT,XWMIN,XWMAX,YWMIN,YWMAX)
		TY=TY-.35
	NEXT IJK%
	CALL SetPen(1)
END SUB
